<?php $__env->startSection('title', 'RASEMCORP || PRIMELAB'); ?>
<?php $__env->startSection('meta-author', 'RASEMCORP'); ?>
<?php $__env->startSection('meta-image', asset('frontend/assets/img/rasemcorp-fav.png')); ?>
<?php $__env->startSection('meta-url', url()->current()); ?>
<?php $__env->startSection('meta-type', 'website'); ?>
<?php $__env->startSection('meta-robots', 'index, follow'); ?>
<?php $__env->startSection('main-content'); ?>

    <main class="main">
        <!-- Hero Section -->
        <section id="hero" class="heroheader section dark-background">
            <div style="position: relative;">
                <div
                    style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; background-color: rgba(0, 0, 0, 0.7); z-index: 1;">
                </div>
                <img src="<?php echo e(asset('frontend/assets/img/hero-bg.jpg')); ?>" alt="" data-aos="fade-in"
                    style="position: relative; z-index: 0;">
            </div>
        </section>
        <!-- /Hero Section -->
        <!-- About Section -->
        <section id="about" class="about section">

            <div class="container" data-aos="fade-up" data-aos-delay="100">
            <div class="row gy-4">
                <div class="col-lg-12 order-1 order-lg-1 content">
                    <h3>PRIMELAB</h3>
                    <p class="fst-italic">
                    Somos una droguería dedicada a la importación, distribución y comercialización de dispositivos
                            médicos y equipamiento de alta calidad para la salud estética. Nuestros principales proveedores
                            son fabricantes suizos e italianos con los más altos estándares de calidad. Asimismo, todos los
                            productos que compramos tienen certificación FDA, así como registro sanitario otorgado por la
                            Dirección General de Medicamento, Insumos y Drogas (DIGEMID). <br>
                            Contamos con el equipo y la infraestructura adecuada para la importación, comercialización y
                            distribución de nuestros productos.
                            <br>
                            Aqui le agregas que contamos con certificacion BPA ( buenas practicas de almacenamiento ) y
                            certificacion BPDT ( Buenas practicas de distribucon y transporte) y certificacion ISO 9001.
                    </p>
                </div>
                <div class="col-lg-6 order-2 order-lg-2">
                    <h3>Información de la Empresa</h3>
                    <!-- <p>
                        <li class="info-item">Razón Social: Clinical Care</li>
                        <li class="info-item">Ruc: 20551480667</li>
                        <li class="info-item">Nombre comercial: Clinical Care</li>
                        <li class="info-item">Fecha de Inicio de actividades: 05/02/2013</li>
                        <li class="info-item">Dirección Legal: Cal. Nova Mza D Lote 11</li>
                        <li class="info-item">Distrito/Ciudad: Ate</li>
                        <li class="info-item">Provincia: Lima</li>
                        <li class="info-item">Departamento: Lima, Perú</li>
                    </p> -->
                    <h4>Certificación</h4>
                    <p>
                        <li class="info-item"><a href="<?php echo e(asset('frontend/assets/img/salud/CERTIFICACIONES/PRIMELAB/CLINICALCAREISO.pdf')); ?>" target="_blank" rel="noopener noreferrer">Certificación de buenas practicas de distribución y transporte</a></li>
                        <li class="info-item"><a href="<?php echo e(asset('frontend/assets/img/salud/CERTIFICACIONES/PRIMELAB/CertBPAMedicPRIME.pdf')); ?>" target="_blank" rel="noopener noreferrer">Certificación de buenas practicas de almacenamiento</a></li>
                        <li class="info-item"><a href="https://primelabperu.com/" target="_blank" rel="noopener noreferrer">Visitanos en nuestra web</a></li>
                    </p>
                    
                </div>
                <div class="col-lg-6 order-3 order-lg-2">
                    <img src="<?php echo e(asset('frontend/assets/img/salud/primelab/primelab.jpg')); ?>" class="img-fluid"
                    alt="">
                </div>
            </div>
            </div>

        </section><!-- /About Section -->
        <!-- Services Section -->
        <section id="services" class="services section">

            <!-- Section Title -->
            <div class="container section-title" data-aos="fade-up">
                <h2>Servicios</h2>
                <p>Salud</p>

            </div><!-- End Section Title -->

            <div class="container">

                <div class="row gy-4">

                    <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="600">
                        <div class="service-item position-relative">
                            <div class="icon2">
                                <img src="<?php echo e(asset('frontend/assets/img/salud/clinical-care/1.jpg')); ?>" class="img-fluid"
                                    alt="">
                            </div>
                            <a href="service-details.html" class="stretched-link">
                                <h3></h3>
                            </a>
                            
                            <a href="service-details.html" class="stretched-link"></a>
                        </div>
                    </div><!-- End Service Item -->
                    <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="400">
                        <div class="service-item position-relative">
                            <div class="icon2">
                                <img src="<?php echo e(asset('frontend/assets/img/salud/clinical-care/2.jpg')); ?>" class="img-fluid"
                                    alt="">
                            </div>
                            <a href="service-details.html" class="stretched-link">
                                <h3></h3>
                            </a>
                            
                            <a href="service-details.html" class="stretched-link"></a>
                        </div>
                    </div><!-- End Service Item -->

                    <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="500">
                        <div class="service-item position-relative">
                            <div class="icon2">
                                <img src="<?php echo e(asset('frontend/assets/img/salud/clinical-care/3.jpg')); ?>" class="img-fluid"
                                    alt="">
                            </div>
                            <a href="service-details.html" class="stretched-link">
                                <h3></h3>
                            </a>
                            
                            <a href="service-details.html" class="stretched-link"></a>
                        </div>
                    </div><!-- End Service Item -->
                    <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-delay="200">
                        <div class="service-item position-relative">
                            <div class="icon2">
                                <img src="<?php echo e(asset('frontend/assets/img/salud/clinical-care/4.jpg')); ?>" class="img-fluid"
                                    alt="">
                            </div>
                            <a href="service-details.html" class="stretched-link">
                                <h3></h3>
                            </a>
                            
                        </div>
                    </div><!-- End Service Item -->

                </div>

            </div>

        </section>
        <!-- /Services Section -->

        <!-- Clients Section -->
        <section id="clients" class="clients section">

            <div class="container" data-aos="fade-up" data-aos-delay="100">

                <div class="swiper init-swiper">
                    <script type="application/json" class="swiper-config">
                {
                  "loop": true,
                  "speed": 600,
                  "autoplay": {
                    "delay": 5000
                  },
                  "slidesPerView": "auto",
                  "pagination": {
                    "el": ".swiper-pagination",
                    "type": "bullets",
                    "clickable": true
                  },
                  "breakpoints": {
                    "320": {
                      "slidesPerView": 2,
                      "spaceBetween": 40
                    },
                    "480": {
                      "slidesPerView": 3,
                      "spaceBetween": 60
                    },
                    "640": {
                      "slidesPerView": 4,
                      "spaceBetween": 80
                    },
                    "992": {
                      "slidesPerView": 6,
                      "spaceBetween": 120
                    }
                  }
                }
              </script>
                    <div class="swiper-wrapper align-items-center">
                        <div class="swiper-slide">
                            <a href="<?php echo e(route('clinical-care')); ?>"><img
                                    src="<?php echo e(asset('frontend/assets/img/salud/clinical-care-logo.png')); ?>" class="img-fluid"
                                    alt=""></a>
                        </div>
                        <div class="swiper-slide">
                            <a href="<?php echo e(route('cedisan')); ?>"><img
                                    src="<?php echo e(asset('frontend/assets/img/salud/cedisan-logo.png')); ?>" class="img-fluid"
                                    alt=""></a>
                        </div>
                        <div class="swiper-slide">
                            <a href="<?php echo e(route('kidney-care')); ?>"><img
                                    src="<?php echo e(asset('frontend/assets/img/salud/kidney-logo.png')); ?>" class="img-fluid"
                                    alt=""></a>
                        </div>
                        <div class="swiper-slide">
                            <a href="<?php echo e(route('hemobalance-care')); ?>"><img
                                    src="<?php echo e(asset('frontend/assets/img/salud/hemobalance-logo.png')); ?>" class="img-fluid"
                                    alt=""></a>
                        </div>
                        <div class="swiper-slide">
                            <a href="<?php echo e(route('jrs-meddev')); ?>"><img
                                    src="<?php echo e(asset('frontend/assets/img/salud/jrs-logo.png')); ?>" class="img-fluid"
                                    alt=""></a>
                        </div>
                        <div class="swiper-slide">
                            <a href="<?php echo e(route('primelab')); ?>"><img
                                    src="<?php echo e(asset('frontend/assets/img/salud/primelab.png')); ?>" class="img-fluid"
                                    alt=""></a>
                        </div>
                        <div class="swiper-slide">
                            <a href="<?php echo e(route('intifarma')); ?>"><img
                                    src="<?php echo e(asset('frontend/assets/img/salud/intifarma-logo.png')); ?>" class="img-fluid"
                                    alt=""></a>
                        </div>
                        <div class="swiper-slide">
                            <a href="<?php echo e(route('pandorafarma')); ?>"><img
                                    src="<?php echo e(asset('frontend/assets/img/salud/pandorafarma-logo.png')); ?>"
                                    class="img-fluid" alt=""></a>
                        </div>
                        <div class="swiper-slide">
                            <a href="<?php echo e(route('tsg-trade')); ?>"><img
                                    src="<?php echo e(asset('frontend/assets/img/ingenieria/tsg-logo.png')); ?>" class="img-fluid"
                                    alt=""></a>
                        </div>
                    </div>
                </div>
                <div class="swiper-pagination"></div>
            </div>

            </div>

        </section><!-- /Clients Section -->

    </main>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .info-item {
        position: relative;
        padding-left: 20px;
        margin-bottom: 5px;
        color: #333;
        transition: color 0.3s ease, transform 0.3s ease;
    }

    .info-item::before {
        content: '';
        position: absolute;
        left: 0;
        color: #007bff;
        font-weight: bold;
        transition: color 0.3s ease;
    }

    .info-item:hover {
        color: #007bff;
        transform: translateX(5px);
    }

    .info-item:hover::before {
        color: #0056b3;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\laragon\www\rasemcorp_web\resources\views/frontend/pages/primelab.blade.php ENDPATH**/ ?>