@extends('frontend.layouts.master')
@section('title', 'RASEMCORP || CONTACTO')
@section('meta-author', 'RASEMCORP')
@section('meta-image', asset('frontend/assets/img/rasemcorp-fav.png'))
@section('meta-url', url()->current())
@section('meta-type', 'website')
@section('meta-robots', 'index, follow')
@section('main-content')

    <main class="main">
        <!-- Hero Section -->
        <section id="hero" class="heroheader section dark-background">
            <div style="position: relative;">
                <div
                    style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; background-color: rgba(0, 0, 0, 0.7); z-index: 1;">
                </div>
                <img src="{{ asset('frontend/assets/img/hero-bg.jpg') }}" alt="" data-aos="fade-in"
                    style="position: relative; z-index: 0;">
            </div>
        </section>
        <!-- /Hero Section -->
        <!-- Contact Section -->
        <section id="contact" class="contact section">

            <!-- Section Title -->
            <div class="container section-title" data-aos="fade-up">
                <h2>Contacto</h2>
                <p>Visitanos en nuestras oficinas</p>
            </div><!-- End Section Title -->

            <div class="container" data-aos="fade-up" data-aos-delay="100">

                <div class="mb-4" data-aos="fade-up" data-aos-delay="200">
                    <iframe style="border:0; width: 100%; height: 270px;"
                        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d4627.655826598832!2d-77.03754082418436!3d-12.094960642801583!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x9105c85d12e190e7%3A0x64bed3df9a586015!2sOficina%20501%2C%20Av.%20Camino%20Real%20159%2C%20San%20Isidro%2015073!5e1!3m2!1ses!2spe!4v1744174292244!5m2!1ses!2spe"
                        frameborder="0" allowfullscreen="" loading="lazy"
                        referrerpolicy="no-referrer-when-downgrade"></iframe>

                </div><!-- End Google Maps -->

                <div class="row gy-4">
                    @php
                        $data = DB::table('settings')->first();
                    @endphp
                    <div class="col-lg-4">
                        <div class="info-item d-flex" data-aos="fade-up" data-aos-delay="300">
                            <i class="bi bi-geo-alt flex-shrink-0"></i>
                            <div>
                                <h3>DIRECCIÓN</h3>
                                @if (!empty($data->address))
                                    <p>

                                        {{ $data->address }}

                                    </p>
                                @endif
                            </div>
                        </div><!-- End Info Item -->

                        <div class="info-item d-flex" data-aos="fade-up" data-aos-delay="400">
                            <i class="bi bi-telephone flex-shrink-0"></i>
                            <div>
                                <h3>Llámanos</h3>
                                @if (!empty($data->phone))
                                    <p class="mt-3"><strong>Phone:</strong> <span>

                                            <a href="tel:{{ $data->phone }}"> {{ $data->phone }} </a>

                                        </span></p>
                                @endif
                            </div>
                        </div><!-- End Info Item -->

                        <div class="info-item d-flex" data-aos="fade-up" data-aos-delay="500">
                            <i class="bi bi-envelope flex-shrink-0"></i>
                            <div>
                                <h3>Email</h3>
                                @if (!empty($data->email))
                                    <p><strong>Email:</strong> <span>

                                            <a href="mailto:{{ $data->email }}">{{ $data->email }}</a> <br>
                                            <a href="mailto:jose.rabanal@rasemcorp.com">jose.rabanal@rasemcorp.com</a>

                                        </span></p>
                                @endif
                            </div>
                        </div><!-- End Info Item -->

                    </div>

                    <div class="col-lg-8">
                        <form action="frontend/forms/contact.php" method="post" class="php-email-form" data-aos="fade-up"
                            data-aos-delay="200">
                            <div class="row gy-4">

                                <div class="col-md-6">
                                    <input type="text" name="name" class="form-control" placeholder="Su nombre"
                                        required="">
                                </div>

                                <div class="col-md-6 ">
                                    <input type="email" class="form-control" name="email" placeholder="Su Email"
                                        required="">
                                </div>

                                <div class="col-md-12">
                                    <input type="text" class="form-control" name="subject" placeholder="Asunto"
                                        required="">
                                </div>

                                <div class="col-md-12">
                                    <textarea class="form-control" name="message" rows="6" placeholder="Mensaje" required=""></textarea>
                                </div>

                                <div class="col-md-12 text-center">
                                    <div class="loading">Loading</div>
                                    <div class="error-message"></div>
                                    <div class="sent-message">Tu mensaje ha sido enviado. ¡Gracias!</div>

                                    <button type="submit">Enviar Mensaje</button>
                                </div>

                            </div>
                        </form>
                    </div><!-- End Contact Form -->

                </div>

            </div>

        </section>
        <!-- /Contact Section -->
    </main>

@endsection

@push('styles')
@endpush

@push('scripts')
@endpush
