@extends('frontend.layouts.master')

@section('title', 'E-TECH || Blog Detail page')

@section('main-content')
    <!-- Breadcrumbs -->
    <div class="breadcrumbs">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="bread-inner">
                        <ul class="bread-list">
                            <li><a href="{{ route('home') }}">Home<i class="ti-arrow-right"></i></a></li>
                            <li class="active"><a href="javascript:void(0);">Blog</a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Breadcrumbs -->

    <!-- Start Blog Single -->
    <section class="blog-single section">
        <div class="container">
            <div class="row">
                <div class="col-lg-8 col-12">
                    <div class="blog-single-main">
                        <div class="row">
                            <div class="col-12">
                                <div class="image">
                                    <img src="{{ $post->photo }}" alt="{{ $post->photo }}">
                                </div>
                                <div class="blog-detail">
                                    <h2 class="blog-title">{{ $post->title }}</h2>
                                    <div class="blog-meta">
                                        <span class="author"><a href="javascript:void(0);"><i class="fa fa-user"></i>By
                                                {{ $post->author_info['name'] }}</a><a href="javascript:void(0);"><i
                                                    class="fa fa-calendar"></i>{{ $post->created_at->format('M d, Y') }}</a><a
                                                href="javascript:void(0);"><i class="fa fa-comments"></i>Comentarios
                                                ({{ $post->allComments->count() }})</a></span>
                                    </div>
                                    <div class="sharethis-inline-reaction-buttons"></div>
                                    <div class="content">
                                        @if ($post->quote)
                                            <blockquote> <i class="fa fa-quote-left"></i> {!! $post->quote !!}
                                            </blockquote>
                                        @endif
                                        <p>{!! $post->description !!}</p>
                                    </div>
                                </div>
                                <div class="share-social">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="content-tags">
                                                <h4>Etiquetas:</h4>
                                                <ul class="tag-inner">
                                                    @php
                                                        $tags = explode(',', $post->tags);
                                                    @endphp
                                                    @foreach ($tags as $tag)
                                                        <li><a href="javascript:void(0);">{{ $tag }}</a></li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @auth
                                <div class="col-12 mt-4">
                                    <div class="reply">
                                        <div class="reply-head comment-form" id="commentFormContainer">
                                            <h2 class="reply-title">Deja un comentario</h2>
                                            <!-- Comment Form -->
                                            <form class="form comment_form" id="commentForm"
                                                action="{{ route('post-comment.store', $post->slug) }}" method="POST">
                                                @csrf
                                                <div class="row">
                                                    {{-- <div class="col-lg-6 col-md-6 col-12">
                                                    <div class="form-group">
                                                        <label>Your Name<span>*</span></label>
                                                        <input type="text" name="name" placeholder="" required="required">
                                                    </div>
                                                </div>
                                                <div class="col-lg-6 col-md-6 col-12">
                                                    <div class="form-group">
                                                        <label>Your Email<span>*</span></label>
                                                        <input type="email" name="email" placeholder="" required="required">
                                                    </div>
                                                </div> --}}
                                                    <div class="col-12">
                                                        <div class="form-group  comment_form_body">
                                                            <label>Tu mensaje<span>*</span></label>
                                                            <textarea name="comment" id="comment" rows="10" placeholder=""></textarea>
                                                            <input type="hidden" name="post_id" value="{{ $post->id }}" />
                                                            <input type="hidden" name="parent_id" id="parent_id"
                                                                value="" />
                                                        </div>
                                                    </div>
                                                    <div class="col-12">
                                                        <div class="form-group button">
                                                            <button type="submit" class="btn"><span
                                                                    class="comment_btn comment">Publicar comentario</span><span
                                                                    class="comment_btn reply" style="display: none;">Responder
                                                                    Comentario</span></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </form>
                                            <!-- End Comment Form -->
                                        </div>
                                    </div>
                                </div>
                            @else
                                <p class="text-center p-5">
                                    Necesitas <a href="{{ route('login.form') }}" style="color:rgb(54, 54, 204)">Iniciar
                                        session</a> O <a style="color:blue" href="{{ route('register.form') }}">Registrarse</a>
                                    para comentar.

                                </p>


                                <!--/ End Form -->
                            @endauth
                            <div class="col-12">
                                <div class="comments">
                                    <h3 class="comment-title">Comentarios ({{ $post->allComments->count() }})</h3>
                                    <!-- Single Comment -->
                                    @include('frontend.pages.comment', [
                                        'comments' => $post->comments,
                                        'post_id' => $post->id,
                                        'depth' => 3,
                                    ])
                                    <!-- End Single Comment -->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-12">
                    <div class="main-sidebar">
                        <!-- Single Widget -->
                        <div class="single-widget search">
                            <form class="form" method="GET" action="{{ route('blog.search') }}">
                                <input type="text" placeholder="Search Here..." name="search">
                                <button class="button" type="sumbit"><i class="fa fa-search"></i></button>
                            </form>
                        </div>
                        <!--/ End Single Widget -->
                        <!-- Single Widget -->
                        <div class="single-widget category">
                            <h3 class="title">Blog Categorias</h3>
                            <ul class="categor-list">
                                {{-- {{count(Helper::postCategoryList())}} --}}
                                @foreach (Helper::postCategoryList('posts') as $cat)
                                    <li><a href="#">{{ $cat->title }} </a></li>
                                @endforeach
                            </ul>
                        </div>
                        <!--/ End Single Widget -->
                        <!-- Single Widget -->
                        <div class="single-widget recent-post">
                            <h3 class="title">Publicación reciente</h3>
                            @foreach ($recent_posts as $post)
                                <!-- Single Post -->
                                <div class="single-post">
                                    <div class="image">
                                        <a href="{{ route('blog.detail', $post->slug) }}">
                                            <img src="{{ $post->photo }}" alt="{{ $post->photo }}">
                                        </a>
                                    </div>
                                    <div class="content">
                                        <h5><a href="{{ route('blog.detail', $post->slug) }}">{{ $post->title }}</a></h5>
                                        <ul class="comment">
                                            <li><i class="fa fa-calendar"
                                                    aria-hidden="true"></i>{{ $post->created_at->format('d M, y') }}</li>
                                            <li><i class="fa fa-user" aria-hidden="true"></i>
                                                {{ $post->author_info->name ?? 'Anonymous' }}
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <!-- End Single Post -->
                            @endforeach
                        </div>
                        <!--/ End Single Widget -->
                        <!-- Single Widget -->
                        <!--/ End Single Widget -->
                        <!-- Single Widget -->
                        <div class="single-widget side-tags">
                            <h3 class="title">Etiquetas</h3>
                            <ul class="tag">
                                @foreach (Helper::postTagList('posts') as $tag)
                                    <li><a href="">{{ $tag->title }}</a></li>
                                @endforeach
                            </ul>
                        </div>
                        <!--/ End Single Widget -->
                        <!-- Single Widget -->
                        <div class="single-widget newsletter">
                            <h3 class="title">Newslatter</h3>
                            <div class="letter-inner">
                                <h4>Suscríbete y recibe noticias y <br> actualizaciones más recientes</h4>
                                <form action="{{ route('subscribe') }}" method="POST">
                                    @csrf
                                    <div class="form-inner">
                                        <input type="email" name="email" placeholder="Enter your email">
                                        <button type="submit" class="btn mt-2">Enviar</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <!--/ End Single Widget -->
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--/ End Blog Single -->
@endsection
@push('styles')
    <script type='text/javascript'
        src='https://platform-api.sharethis.com/js/sharethis.js#property=5f2e5abf393162001291e431&product=inline-share-buttons'
        async='async'></script>
@endpush
@push('scripts')
    <script>
        $(document).ready(function() {

            (function($) {
                "use strict";

                $('.btn-reply.reply').click(function(e) {
                    e.preventDefault();
                    $('.btn-reply.reply').show();

                    $('.comment_btn.comment').hide();
                    $('.comment_btn.reply').show();

                    $(this).hide();
                    $('.btn-reply.cancel').hide();
                    $(this).siblings('.btn-reply.cancel').show();

                    var parent_id = $(this).data('id');
                    var html = $('#commentForm');
                    $(html).find('#parent_id').val(parent_id);
                    $('#commentFormContainer').hide();
                    $(this).parents('.comment-list').append(html).fadeIn('slow').addClass('appended');
                });

                $('.comment-list').on('click', '.btn-reply.cancel', function(e) {
                    e.preventDefault();
                    $(this).hide();
                    $('.btn-reply.reply').show();

                    $('.comment_btn.reply').hide();
                    $('.comment_btn.comment').show();

                    $('#commentFormContainer').show();
                    var html = $('#commentForm');
                    $(html).find('#parent_id').val('');

                    $('#commentFormContainer').append(html);
                });

            })(jQuery)
        })
    </script>
@endpush
