<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLibroReclamacionesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('libro_reclamaciones', function (Blueprint $table) {
            $table->id();
            $table->date('fecha');
            $table->string('nombre_y_apellidos');
            $table->string('direccion');
            $table->string('distrito');
            $table->string('documento_tipo');
            $table->string('documento_numero');
            $table->string('email');
            $table->string('telefono');
            $table->string('padre_o_madre')->nullable();
            $table->boolean('producto')->default(false);
            $table->boolean('servicio')->default(false);
            $table->boolean('reclamo')->default(false);
            $table->boolean('queja')->default(false);
            $table->text('detalle');
            $table->enum('estado', ['pendiente', 'atendido', 'rechazado'])->default('pendiente');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('libro_reclamaciones');
    }
}
