<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\LibroReclamaciones;
use Illuminate\Database\Eloquent\SoftDeletes;

class Respuesta extends Model
{
    use HasFactory, SoftDeletes;
    protected $primaryKey = 'id';
    protected $table = 'respuestas';

    protected $fillable = [
        'libro_reclamaciones_id',
        'respuesta',
        'tipo',
    ];

    public function libroReclamaciones()
    {
        return $this->belongsTo(LibroReclamaciones::class);
    }
}
